<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TipoVentaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Verificar si ya existen datos para evitar duplicados
        $existentes = DB::table('tipo_ventas')->count();
        
        if ($existentes === 0) {
            DB::table('tipo_ventas')->insert([
                [
                    'nombre_tipo_ventas' => 'contado',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'nombre_tipo_ventas' => 'crédito',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
            ]);
            
            $this->command->info('Tipos de venta creados exitosamente.');
        } else {
            $this->command->info('Ya existen tipos de venta en la base de datos.');
        }
    }
}

