<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LowStockNotification extends Notification
{
    use Queueable;

    protected $product;
    protected $currentStock;

    /**
     * Create a new notification instance.
     */
    public function __construct($product, $currentStock = null)
    {
        $this->product = $product;
        $this->currentStock = $currentStock;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->line('The introduction to the notification.')
            ->action('Notification Action', url('/'))
            ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $stockInfo = $this->currentStock !== null ? " (Stock actual: {$this->currentStock})" : '';

        return [
            'title' => 'Stock Bajo',
            'message' => "El producto '{$this->product->nombre}' tiene un stock bajo{$stockInfo}.",
            'type' => 'warning',
            'product_id' => $this->product->id,
        ];
    }
}
