<?php

namespace App\Exports;

use App\Models\Proveedor;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithTitle;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ProveedoresExport implements FromCollection, WithHeadings, WithStyles, WithColumnWidths, WithTitle
{
    public function collection()
    {
        return Proveedor::all()
            ->map(function ($proveedor) {
                return [
                    'nombre' => $proveedor->nombre,
                    'telefono' => $proveedor->telefono ?? 'N/A',
                    'email' => $proveedor->email ?? 'N/A',
                    'nit' => $proveedor->nit ?? 'N/A',
                    'direccion' => $proveedor->direccion ?? 'N/A',
                    'tipo_proveedor' => $proveedor->tipo_proveedor ?? 'General',
                    'estado' => $proveedor->estado ? 'Activo' : 'Inactivo',
                ];
            });
    }

    public function headings(): array
    {
        return [
            'Nombre',
            'Teléfono',
            'Email',
            'NIT',
            'Dirección',
            'Tipo Proveedor',
            'Estado',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => [
                'font' => ['bold' => true, 'size' => 12, 'color' => ['rgb' => 'FFFFFF']],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '3B82F6']
                ],
            ],
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 30,
            'B' => 15,
            'C' => 25,
            'D' => 15,
            'E' => 35,
            'F' => 20,
            'G' => 12,
        ];
    }

    public function title(): string
    {
        return 'Proveedores';
    }
}
